<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('zone_master', function (Blueprint $table) {
            $table->bigIncrements('Zon_Id');
            $table->string('Zon_Code', 5)->nullable();
            $table->string('Zon_Name', 25);
            $table->unsignedBigInteger('Org_Id')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('Org_Id')
                  ->references('Org_Id')
                  ->on('org_master')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('zone_master');
    }
};
