<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ward_master', function (Blueprint $table) {

            $table->bigIncrements('Wrd_Id');

            $table->string('Wrd_Code', 5)->nullable();

            $table->string('Wrd_Name', 25);

            $table->unsignedBigInteger('Zon_Id');

            $table->tinyInteger('is_active')->default(1);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

            $table->foreign('Zon_Id')
          ->references('Zon_Id')
          ->on('zone_master')
          ->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ward_master');
    }
};
