<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('area_master', function (Blueprint $table) {

            $table->bigIncrements('Are_Id');

            $table->string('Are_Code', 6)->nullable();

            $table->string('Are_Name', 50);

            $table->unsignedBigInteger('Wrd_Id')->nullable();

            $table->foreign('Wrd_Id')
      ->references('Wrd_Id')
      ->on('ward_master')
      ->onDelete('cascade')
      ->onUpdate('cascade');


            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('area_master');
    }
};
