<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ccc_master', function (Blueprint $table) {

            $table->bigIncrements('CCC_Id');

            $table->string('CCC_Code', 20)->nullable();
            $table->string('CCC_Name', 50);

            $table->unsignedBigInteger('Wrd_Id');

            $table->tinyInteger('is_active')->default(1);

            $table->timestamps();
            $table->softDeletes();

            // ✅ Foreign Key
            $table->foreign('Wrd_Id')
                  ->references('Wrd_Id')
                  ->on('ward_master')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ccc_master');
    }
};
