<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grant_autho_master', function (Blueprint $table) {

            $table->bigIncrements('GA_Id');

            $table->string('GA_Code', 50)->nullable();
            $table->string('GA_Name', 50);

            $table->tinyInteger('is_active')->default(1);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grant_autho_master');
    }
};
