<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grant_type_master', function (Blueprint $table) {

            $table->bigIncrements('GT_Id');

            $table->string('GT_Code', 25)->nullable();
            $table->string('GT_Name', 50);
            $table->string('GT_Nature', 25)->nullable(); // Revenue / Capital

            $table->enum('GT_Condition', ['Y', 'N'])->default('N');

            $table->date('GT_Utl_From_Date')->nullable();
            $table->date('GT_Utl_To_Date')->nullable();

            $table->string('GT_Act_Mode', 50)->nullable(); // Income / Liability / Differed

            $table->unsignedBigInteger('GT_Au_Id')->nullable();

            $table->string('GT_Status', 25)->default('Active');

            $table->tinyInteger('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes();

            // Foreign Key
            $table->foreign('GT_Au_Id')
                  ->references('GA_Id')
                  ->on('grant_autho_master')
                  ->onDelete('restrict')
                  ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grant_type_master');
    }
};
