<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grant_cat_master', function (Blueprint $table) {

            $table->bigIncrements('GC_Id'); // Primary Key (UNSIGNED AUTO_INCREMENT)

            $table->string('GC_Name', 50); // NOT NULL

            $table->string('GC_Code', 50)->nullable(); // NULL

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grant_cat_master');
    }
};
