<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ledg_grps', function (Blueprint $table) {

            $table->bigIncrements('Gr_Id'); // Primary Key (UNSIGNED AUTO_INCREMENT)

            $table->string('Gr_Cd', 8)->nullable();

            $table->string('Up_Gr', 8)->nullable();

            $table->string('Gr_Nm', 50)->nullable();

            $table->bigInteger('Gr_Sr')->nullable();

            $table->bigInteger('Gr_St')->nullable();

            $table->string('is_del', 1)->nullable();

            $table->string('Gr_Exp', 1)->nullable();

            $table->string('Gr_Buk', 1)->nullable();

            $table->string('Gr_Prt', 1)->nullable();

            $table->timestamp('created_at')->nullable();

            $table->timestamp('updated_at')->nullable();

            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ledg_grps');
    }
};
