<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ledger_master', function (Blueprint $table) {

            $table->bigIncrements('Lg_Id');

            $table->string('Lg_Code', 50)->nullable();

            $table->unsignedBigInteger('Gr_Id')->nullable();

            $table->string('Lg_Name', 100);
            $table->string('Lg_Eng_Name', 150)->nullable();

            $table->text('Lg_Address')->nullable();
            $table->string('Lg_City', 50)->nullable();
            $table->string('Lg_Pin', 20)->nullable();
            $table->string('Lg_Phone', 15)->nullable();
            $table->string('Lg_Email', 50)->nullable();

            $table->string('Lg_Sub', 100)->nullable();
            $table->string('Lg_Buk', 100)->nullable();

            $table->decimal('Lg_Cr_Lim', 15, 2)->default(0.00);
            $table->decimal('Lg_Drw_Pwr', 15, 2)->default(0.00);

            $table->tinyInteger('Lg_Status')->default(1)->comment('0=Inactive, 1=Active');

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

            // ✅ Foreign Key
            $table->foreign('Gr_Id')
                  ->references('Gr_Id')
                  ->on('ledg_grps')
                  ->onDelete('restrict')
                  ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ledger_master');
    }
};
