<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('scheme_master', function (Blueprint $table) {

            $table->bigIncrements('Sch_id');

            $table->string('Sch_Code', 30);
            $table->string('Sch_Name', 50);

            $table->unsignedBigInteger('Dept_Id')->nullable();
            $table->unsignedBigInteger('GT_Id')->nullable();

            $table->date('St_Date')->nullable();
            $table->date('Ed_Date')->nullable();

            $table->decimal('Budget', 15, 2)->nullable();

            $table->string('Status', 15)->default('ACTIVE');
            $table->boolean('Is_Active')->default(1);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

            // Foreign Keys (Optional – remove if not needed)
            $table->foreign('Dept_Id')
                  ->references('Dpt_Id')
                  ->on('dept_master')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');

            $table->foreign('GT_Id')
                  ->references('GT_Id')
                  ->on('grant_type_master')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('scheme_master');
    }
};

