<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('debt_type_master', function (Blueprint $table) {

            $table->bigIncrements('DT_id');

            $table->string('DT_Code', 20)->nullable();
            $table->string('DT_Name', 50);

            $table->enum('DT_Cate', ['Long Term', 'Short Term'])->nullable();

            $table->enum('DT_Lia_type', ['Payable', 'Deposit', 'Loan'])->nullable();

            $table->tinyInteger('Is_Active')->default(1);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('debt_type_master');
    }
};
