<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subledg_master', function (Blueprint $table) {

            $table->bigIncrements('SL_Id');
            $table->longText('Lg_Id');

            $table->string('SL_Code', 50)->nullable();
            $table->string('SL_Name', 150);
            $table->text('SL_Address')->nullable();
            $table->string('SL_City', 50)->nullable();
            $table->string('SL_Pin', 20)->nullable();
            $table->string('SL_Phone', 15)->nullable();
            $table->string('SL_Email', 50)->nullable();
            $table->string('SL_Cont_Pers', 50)->nullable()->comment('Contact Person Name');

            $table->decimal('SL_Cr_Lim', 15, 2)->default(0.00);
            $table->decimal('SL_Draw_Pwr', 15, 2)->default(0.00);
            $table->tinyInteger('SL_Status')->default(1)->comment('0=Inactive, 1=Active');

            $table->string('PAN_Number', 10)->nullable();
            $table->tinyInteger('PAN_Verified')->default(0);
            $table->date('PAN_Verified_Date')->nullable();

            $table->string('GSTIN', 15)->nullable();
            $table->tinyInteger('GSTIN_Verified')->default(0);
            $table->date('GSTIN_Verified_Date')->nullable();
            $table->string('GST_Exempt_Declaration', 255)->nullable();
            $table->string('MSME_Udyam_Registration_No', 19)->nullable();
            $table->string('CIN_LIPIN', 21)->nullable();
            $table->string('Shop_Act_Trade_License_No', 50)->nullable();
            $table->string('TAN', 10)->nullable();

            $table->string('Bank_Name', 50)->nullable();
            $table->string('Branch_Name', 50)->nullable();
            $table->string('Account_Holder_Name', 50)->nullable();
            $table->string('Account_Number', 18)->nullable();
            $table->string('IFSC_Code', 20)->nullable();

            $table->enum('Account_Type', ['Savings','Current','OD','CC','NRI','Other'])->nullable();

            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subledg_master');
    }
};
