<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pay_comm_master', function (Blueprint $table) {

            $table->bigIncrements('PC_Id');

            $table->string('PC_Name', 50);

            $table->unsignedBigInteger('PST_Id')->nullable();

            $table->text('PST_Desc')->nullable();

            $table->date('Eff_From');

            $table->date('Eff_To')->nullable();

            $table->tinyInteger('Is_Active')->default(1);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();


            $table->foreign('PST_Id')
                ->references('PST_Id')
                ->on('pay_strtype_master')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pay_comm_master');
    }
};
