<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pay_band_master', function (Blueprint $table) {

            $table->bigIncrements('PB_Id');

            $table->unsignedBigInteger('PC_Id');

            $table->string('PB_Code',20);

            $table->decimal('Min_Pay',10,2);

            $table->decimal('Max_Pay',10,2);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

            
            $table->foreign('PC_Id')
                  ->references('PC_Id')
                  ->on('pay_comm_master')
                   ->onDelete('cascade')
                ->onUpdate('cascade');
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pay_band_master');
    }
};
