<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('subledg_master', function (Blueprint $table) {
            // Add the correctly named column (exact same type & attributes as original)
            $table->string('CIN_LLPIN', 21)->nullable();
            // Optional: place it in the same position as old one
            // ->after('MSME_Udyam_Registration_No');
        });

        // Copy all existing data over
        DB::statement('UPDATE subledg_master SET CIN_LLPIN = CIN_LIPIN');

        // Now safe to drop the old column
        Schema::table('subledg_master', function (Blueprint $table) {
            $table->dropColumn('CIN_LIPIN');
        });
    }

    public function down(): void
    {
        // Reverse steps: recreate old column
        Schema::table('subledg_master', function (Blueprint $table) {
            $table->string('CIN_LIPIN', 21)->nullable();
            // ->after('MSME_Udyam_Registration_No');
        });

        DB::statement('UPDATE subledg_master SET CIN_LIPIN = CIN_LLPIN');

        Schema::table('subledg_master', function (Blueprint $table) {
            $table->dropColumn('CIN_LLPIN');
        });
    }
};
