<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emp_grade_master', function (Blueprint $table) {

            $table->bigIncrements('EGM_Id');

            $table->string('EGM_Code', 10)->nullable();

            $table->string('EGM_Name', 50);

            $table->unsignedBigInteger('PB_ID')->nullable();

            $table->tinyInteger('Is_Active')->default(1);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

            // 👉 Optional foreign key (if pay_band_master relation needed)
            $table->foreign('PB_ID')
                ->references('PB_Id')
                ->on('pay_band_master')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emp_grade_master');
    }
};
