<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pay_scale_master', function (Blueprint $table) {

            $table->bigIncrements('PS_Id');

            $table->unsignedBigInteger('PC_Id');

            $table->string('Scl_Code', 20);

            $table->decimal('St_Basic', 10, 2);
            $table->decimal('Inc_Amount', 10, 2);

            $table->integer('Inc_Steps');

            $table->decimal('Max_Basic', 10, 2);

            $table->timestamps();
            $table->softDeletes();

            // optional FK (add only if pay_commission table exists)
            $table->foreign('PC_Id')->references('PC_Id')->on('pay_comm_master')
               ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pay_scale_master');
    }
};
