<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_charge_master', function (Blueprint $table) {
            $table->id('IC_Id'); // Primary key
            $table->string('IC_Code', 20);
            $table->string('IC_Name', 100);
            $table->decimal('Percentage', 5, 2)->default(0.00);
            $table->unsignedBigInteger('Lg_Id')->nullable();
            $table->timestamps(); // created_at & updated_at
            $table->softDeletes(); // deleted_at

            $table->foreign('Lg_Id')
              ->references('Lg_Id')                  // ← ledger_master का primary key column
              ->on('ledger_master')
              ->onDelete('set null');             // जरूरत के हिसाब से बदल सकते हो
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_charge_master');
    }
};
