<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emp_type_master', function (Blueprint $table) {

            $table->bigIncrements('ETy_Id');

            $table->string('ETy_Code', 20)->nullable();
            $table->string('ETy_Name', 50);

            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes(); // deleted_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emp_type_master');
    }
};
