<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
{
    Schema::create('grant_dept_map', function (Blueprint $table) {
        $table->id('GDM_Id');
        $table->unsignedBigInteger('Dept_Id')->nullable();  

        $table->json('Lg_Ids')->nullable();

        $table->tinyInteger('Status')->default(1);

        $table->timestamps();
        $table->softDeletes();

        // सिर्फ Dept_Id पर foreign key
        $table->foreign('Dept_Id')
              ->references('Dpt_id')
              ->on('dept_master')
              ->onDelete('restrict')
              ->onUpdate('cascade');
    });
}
};
