<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('funds_type_master', function (Blueprint $table) {
            $table->bigIncrements('FT_id');

            $table->string('FT_Code', 20)->nullable();
            $table->string('FT_Name', 100);
            $table->string('FT_Type', 50)->nullable();
            $table->string('FT_Source', 50)->nullable();

            $table->unsignedBigInteger('GT_Id')->nullable();

            $table->string('FT_Category', 20)->nullable();

            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes();


            $table->foreign('GT_Id')
              ->references('GT_Id')
              ->on('grant_type_master')          // टेबल नाम confirm करो
              ->onDelete('set null')             // या 'restrict', 'cascade'
              ->onUpdate('cascade');
        });


    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('funds_type_master');
    }
};
