<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('designation_master', function (Blueprint $table) {
            $table->bigIncrements('Dsg_id'); // Primary Key

            $table->string('Dsg_Title', 50)->nullable();
            $table->string('Dsg_Desc', 255)->nullable();
            $table->string('Dsg_EName', 50)->nullable();
            $table->string('UpGrp', 20)->nullable();
            $table->string('GrCod', 20)->nullable();
            $table->string('GrSrn', 20)->nullable();
            $table->string('GrStt', 20)->nullable();

            $table->tinyInteger('isvisible')
                ->default(1)
                ->comment('0=Inactive, 1=Active');

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('designation_master');
    }
};
