<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('inc_exam_master', function (Blueprint $table) {
            $table->id('EEd_Id');
            $table->string('EEd_Code', 20)->nullable();
            $table->string('EEd_Name', 100);
            $table->boolean('Is_Active')->default(1);
            $table->enum('Is_Mandatory', ['Y', 'N'])->default('N');
            $table->enum('Is_Technical', ['Y', 'N'])->default('N');
            $table->enum('Is_Professional', ['Y', 'N'])->default('N');
            $table->enum('Is_Promotional', ['Y', 'N'])->default('N');
            $table->enum('Rec_Valid', ['Y', 'N'])->default('N');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('inc_exam_master');
    }
};
