<?php
// database/migrations/2024_01_01_000000_create_holiday_master_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHolidayMasterTable extends Migration
{
    public function up()
    {
        Schema::create('holiday_master', function (Blueprint $table) {
            $table->bigIncrements('HL_Id');
            $table->string('HL_Code', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_Name', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('CI_Year', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_Date', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_Type', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_Cate', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_ISPaid', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_ISOptional', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_ISCmpnst', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_AttnImpact', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_PayImpact', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->string('HL_OTAllowed', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->tinyInteger('HL_Status')->default(1);
            $table->string('Remarks', 255)->nullable()->collation('utf8mb4_unicode_ci');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('holiday_master');
    }
}
