<?php
// database/migrations/2024_01_01_000001_create_holiday_dept_map_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHolidayDeptMapTable extends Migration
{
    public function up()
    {
        Schema::create('Holiday_Dept_Map', function (Blueprint $table) {
            $table->bigIncrements('HLDp_Id');
            $table->bigInteger('HL_Id')->unsigned()->nullable();
            $table->bigInteger('Dpt_id')->unsigned()->nullable();
            $table->tinyInteger('HD_Status')->default(1);
            $table->timestamps();
            $table->softDeletes();


             // Foreign key constraints
            $table->foreign('HL_Id')
                  ->references('HL_Id')
                  ->on('holiday_master')
                  ->onDelete('set null')
                  ->onUpdate('cascade');

            $table->foreign('Dpt_id')
                  ->references('Dpt_id')
                  ->on('dept_master')
                  ->onDelete('set null')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('Holiday_Dept_Map');
    }
}
