<?php
// database/migrations/2024_01_01_000002_create_holiday_dsg_map_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHolidayDsgMapTable extends Migration
{
    public function up()
    {
        Schema::create('Holiday_Dsg_Map', function (Blueprint $table) {
            $table->bigIncrements('HLDS_Id');
            $table->bigInteger('HL_Id')->unsigned()->nullable();
            $table->bigInteger('Dsg_Id')->unsigned()->nullable();
            $table->tinyInteger('HDS_Status')->default(1);
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('HL_Id')
                  ->references('HL_Id')
                  ->on('holiday_master')
                  ->onDelete('set null')
                  ->onUpdate('cascade');

            $table->foreign('Dsg_Id')
                  ->references('Dsg_Id')
                  ->on('designation_master')
                  ->onDelete('set null')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('Holiday_Dsg_Map');
    }
}
