<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emp_quota_master', function (Blueprint $table) {
            $table->bigIncrements('Qut_Id');
            $table->string('Qut_Code', 20)->nullable();
            $table->string('Qut_Name', 50);
            $table->decimal('Percentage', 5, 2)->nullable();
            $table->boolean('Is_Active')->default(1);
            $table->timestamps(); // created_at & updated_at
            $table->softDeletes(); // deleted_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emp_quota_master');
    }
};
