<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emp_cat_master', function (Blueprint $table) {

            $table->bigIncrements('ECt_Id');

            $table->string('ECt_Code', 20)->nullable();

            $table->string('ECt_Name', 50);

            $table->tinyInteger('Is_Active')->default(1);

            $table->timestamps();

            $table->softDeletes(); // deleted_at column
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emp_cat_master');
    }
};
