<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHolidayEmpTyMapTable extends Migration
{
    public function up()
    {
        Schema::create('Holiday_EmpTy_Map', function (Blueprint $table) {
            $table->bigIncrements('HLET_Id');
            $table->bigInteger('HL_Id')->unsigned();
            $table->bigInteger('ETy_Id')->unsigned();
            $table->tinyInteger('HET_Status')->default(1);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('HL_Id')
                  ->references('HL_Id')
                  ->on('Holiday_Master')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');

            $table->foreign('ETy_Id')
                  ->references('ETy_Id')
                  ->on('emp_type_master')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('Holiday_EmpTy_Map');
    }
}
