<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emp_lang_master', function (Blueprint $table) {
            $table->bigIncrements('ELg_Id'); // Primary Key
            $table->string('ELg_Code', 10)->nullable();
            $table->string('Elg_Name', 50);
            $table->boolean('Is_Active')->default(1);

            $table->timestamps(); // created_at & updated_at
            $table->softDeletes(); // deleted_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emp_lang_master');
    }
};
