<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('employee_master', function (Blueprint $table) {

            $table->bigIncrements('Emp_Id');

            $table->string('Emp_Code', 20)->nullable();
            $table->string('First_Name', 50);
            $table->string('Last_Name', 50)->nullable();

            $table->unsignedBigInteger('Dpt_Id')->nullable();
            $table->unsignedBigInteger('Caste_Id')->nullable();
            $table->unsignedBigInteger('Qut_Id')->nullable();
            $table->unsignedBigInteger('Ect_Id')->nullable();
            $table->unsignedBigInteger('Usr_Id')->nullable();
            $table->longText('ELg_Id')->nullable();
            $table->string('Phone', 15)->nullable();
            $table->string('Email_Id', 50)->nullable();
            $table->string('Alt_Phone', 15)->nullable();
            $table->string('F_M', 10)->nullable();

            $table->string('Emp_Add1', 100)->nullable();
            $table->string('Emp_Add2', 100)->nullable();
            $table->string('Emp_Add3', 100)->nullable();

            $table->date('Birth_Date')->nullable();

            $table->string('Bank_AcNo', 30)->nullable();
            $table->string('Bank_Name', 50)->nullable();
            $table->string('Bank_Br_Name', 50)->nullable();
            $table->string('BkAc_Type', 25)->nullable();

            $table->string('Gpf_AcNo_Pref', 50)->nullable();
            $table->string('Gpf_AcNo', 30)->nullable();
            $table->string('Cpf_AcNo', 30)->nullable();
            $table->string('Inc_TxNo', 25)->nullable();
            $table->string('UID_AdharNo', 20)->nullable();

            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes();

            /*
            ========================
            Foreign Keys
            ========================
            */

            $table->foreign('Dpt_Id')
                ->references('Dpt_id')
                ->on('dept_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreign('Caste_Id')
                ->references('Caste_Id')
                ->on('caste_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreign('Qut_Id')
                ->references('Qut_Id')
                ->on('emp_quota_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreign('Ect_Id')
                ->references('ECt_Id')
                ->on('emp_cat_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreign('Usr_Id')
                ->references('Usr_Id')
                ->on('user_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employee_master');
    }
};
