<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHolidayShiftMapTable extends Migration
{
    public function up()
    {
        Schema::create('Holiday_Shift_Map', function (Blueprint $table) {
            $table->bigIncrements('HLSF_Id');
            $table->bigInteger('HL_Id')->unsigned()->nullable();
            $table->bigInteger('Sf_Id')->unsigned()->nullable();
            $table->tinyInteger('HDS_Status')->default(1);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('HL_Id')
                  ->references('HL_Id')
                  ->on('Holiday_Master')
                  ->onDelete('set null')
                  ->onUpdate('cascade');

            $table->foreign('Sf_Id')
                  ->references('Sf_Id')
                  ->on('shift_master')
                  ->onDelete('set null')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('Holiday_Shift_Map');
    }
}
