<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveTypeMasterTable extends Migration
{
    public function up()
    {
        Schema::create('leave_type_master', function (Blueprint $table) {
            $table->bigIncrements('LT_id');
            $table->string('LT_code', 20)->nullable();
            $table->string('LT_name', 100)->nullable(false);
            $table->integer('Max_days')->nullable();
            $table->boolean('Is_Paid')->default(1);
            $table->boolean('Is_Active')->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('leave_type_master');
    }
}
