<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('award_master', function (Blueprint $table) {
            $table->bigIncrements('Awrd_Id'); // Primary Key

            $table->string('Awrd_Code', 20)->nullable();
            $table->string('Awrd_Name', 50);
            $table->integer('Awrd_Year')->nullable();
            $table->string('Awrding_Auth', 100)->nullable();

            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes(); // deleted_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('award_master');
    }
};
