<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('emp_edu_master', function (Blueprint $table) {
            $table->bigIncrements('EEd_Id');
            $table->string('EEd_Code', 20)->nullable();
            $table->string('EEd_Name', 50);
            $table->boolean('Is_Active')->default(1);
            $table->enum('Is_Mandatory', ['Y', 'N'])->default('N');
            $table->enum('Is_Technical', ['Y', 'N'])->default('N');
            $table->enum('Is_Professional', ['Y', 'N'])->default('N');
            $table->enum('Is_Promotional', ['Y', 'N'])->default('N');
            $table->enum('Rec_Valid', ['Y', 'N'])->default('N');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('emp_edu_master');
    }
};
