<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('family_info_master', function (Blueprint $table) {

            $table->bigIncrements('EFI_Id');

            $table->unsignedBigInteger('Emp_id')->nullable();
            $table->string('Member_name', 50);
            $table->enum('Gender', ['male', 'female', 'other'])->nullable();
            $table->unsignedBigInteger('Rela_Id')->nullable();
            $table->date('Dob')->nullable();
            $table->string('Phone', 15)->nullable();
            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes();

            // ✅ Foreign Key
            $table->foreign('Emp_id')
                ->references('Emp_Id')
                ->on('employee_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreign('Rela_Id')
                ->references('Rela_Id')
                ->on('relationship_master')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('family_info_master');
    }
};
