<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('special_duty_master', function (Blueprint $table) {

            $table->bigIncrements('SDt_Id');

            $table->string('SDt_Code', 20)->nullable();
            $table->string('SDt_Name', 50);

            $table->string('SDt__Desc', 150)->nullable();
            $table->date('SDt__SDate')->nullable();
            $table->date('SDt__EDate')->nullable();

            $table->boolean('SDt_Fees')->default(1);
            $table->boolean('Is_Reimburse')->default(1);
            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('special_duty_master');
    }
};
