<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pay_alwded_master', function (Blueprint $table) {

            $table->bigIncrements('PAD_Id');

            $table->string('PAD_Code', 20);
            $table->string('PAD_ShortName', 20);
            $table->string('PAD_Name', 100);

            $table->decimal('Percentage', 5, 2)->default(0.00);

            $table->string('Alw_Ded', 1)->nullable();

            // Foreign Key
            $table->unsignedBigInteger('Lg_Id')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // FK Relation with ledger_master
            $table->foreign('Lg_Id')
                ->references('Lg_Id')
                ->on('ledger_master')
                ->onDelete('set null')
                ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pay_alwded_master');
    }
};
