<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('emppers_profile', function (Blueprint $table) {

            $table->bigIncrements('EPP_Id');

            $table->unsignedBigInteger('Emp_Id')->nullable();
            $table->date('EPP_Date')->nullable();
            $table->unsignedBigInteger('EGM_Id')->nullable();
            $table->unsignedBigInteger('Dpt_id')->nullable();
            $table->unsignedBigInteger('Dsg_Id')->nullable();
            $table->unsignedBigInteger('PS_Id')->nullable();
            $table->unsignedBigInteger('ETy_Id')->nullable();
            $table->date('Join_Date')->nullable();
            $table->unsignedBigInteger('Est_Id')->nullable();
            $table->boolean('Is_Active')->default(1);

            $table->timestamps();
            $table->softDeletes();

            // ✅ Foreign Keys

            $table->foreign('Emp_Id')
                ->references('Emp_Id')->on('employee_master')
                ->onDelete('restrict')->onUpdate('cascade');

            $table->foreign('EGM_Id')
                ->references('EGM_Id')->on('emp_grade_master')
                ->onDelete('restrict')->onUpdate('cascade');

            $table->foreign('Dpt_id')
                ->references('Dpt_id')->on('dept_master')
                ->onDelete('restrict')->onUpdate('cascade');

            $table->foreign('Dsg_Id')
                ->references('Dsg_id')->on('designation_master')
                ->onDelete('restrict')->onUpdate('cascade');

            $table->foreign('PS_Id')
                ->references('PS_Id')->on('pay_scale_master')
                ->onDelete('restrict')->onUpdate('cascade');

            $table->foreign('ETy_Id')
                ->references('ETy_Id')->on('emp_type_master')
                ->onDelete('restrict')->onUpdate('cascade');

            $table->foreign('Est_Id')
                ->references('Est_Id')->on('emp_status_master')
                ->onDelete('restrict')->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('emppers_profile');
    }
};
