<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vendinv_parameter', function (Blueprint $table) {

            $table->bigIncrements('VIP_Id');

            $table->unsignedBigInteger('TnT_ID')->nullable();
            $table->date('Eff_Date');
            $table->unsignedBigInteger('VIP_Sr')->nullable();
            $table->unsignedBigInteger('IC_Id')->nullable();
            $table->string('Add_Dedu', 50)->nullable();
            $table->unsignedBigInteger('Lg_Id')->nullable();
            $table->decimal('Percent', 10, 2)->nullable();
            $table->string('Formula', 100)->nullable();

            $table->timestamps();
            $table->softDeletes();

            // Optional Foreign Keys (agar chaho to enable karo)

            $table->foreign('TnT_ID')->references('TnT_ID')->on('tender_type');
            $table->foreign('IC_Id')->references('IC_Id')->on('invoice_charge_master');
            $table->foreign('Lg_Id')->references('Lg_Id')->on('ledger_master');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vendinv_parameter');
    }
};
