<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('branch_master', function (Blueprint $table) {

            $table->bigIncrements('Br_Id');

            $table->string('Br_Name',100);
            $table->string('Br_Code',25)->nullable();

            $table->string('Br_GST_No',50)->nullable();
            $table->string('Br_TDS_No',50)->nullable();
            $table->string('Br_PAN_No',50)->nullable();

            $table->text('Br_Address')->nullable();
            $table->string('Br_City',50)->nullable();
            $table->string('Br_State',50)->nullable();
            $table->string('Br_Pin',10)->nullable();

            $table->string('Br_Email',50)->nullable();
            $table->string('Br_Mobile',15)->nullable();

            $table->string('Br_URL',150)->nullable();
            $table->string('Br_Logo',200)->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branch_master');
    }
};
