<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('dept_wrokflow', function (Blueprint $table) {

            $table->bigIncrements('DWF_Id');

            $table->date('Wef_Date')->nullable();

            $table->unsignedBigInteger('Dpt_Id')->nullable();
            $table->unsignedBigInteger('Dsg_Id')->nullable();
            $table->unsignedBigInteger('Emp_Id')->nullable();

            $table->string('Trn_SrNo', 50)->nullable();
            $table->string('Trn_Stage', 150)->nullable();
            $table->string('Trn_Method', 50)->nullable();
            $table->string('Trn_Tet', 100)->nullable();

            $table->timestamps();

            // Foreign Keys
            $table->foreign('Dpt_Id')
                ->references('Dpt_id')
                ->on('dept_master')
                ->onDelete('restrict')
                ->onUpdate('cascade');

            $table->foreign('Dsg_Id')
                ->references('Dsg_id')
                ->on('designation_master')
                ->onDelete('restrict')
                ->onUpdate('cascade');

            $table->foreign('Emp_Id')
                ->references('Emp_Id')
                ->on('employee_master')
                ->onDelete('restrict')
                ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('dept_wrokflow');
    }
};
