<?php

use App\Http\Controllers\AreaMasterController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CccMasterController;
use App\Http\Controllers\DebtTypeMasterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoleMasterController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\FunctionTypeController;
use App\Http\Controllers\UserMasterController;
use App\Http\Controllers\UsrDeptMapController;
use App\Http\Controllers\DeptMenuMapController;
use App\Http\Controllers\EmdbgTypeController;
use App\Http\Controllers\FundsTypeMasterController;
use App\Http\Controllers\FyearMasterController;
use App\Http\Controllers\GrantAuthoMasterController;
use App\Http\Controllers\GrantTypeMasterController;
use App\Http\Controllers\OrgMasterController;
use App\Http\Controllers\ParameterController;
use App\Http\Controllers\WardMasterController;
use App\Http\Controllers\ZoneMasterController;
use App\Http\Controllers\GrantCatMasterController;
use App\Http\Controllers\LedgerMasterController;
use App\Http\Controllers\LedgGrpController;
use App\Http\Controllers\SchemeMasterController;
use App\Http\Controllers\SubLedgerMasterController;
use App\Http\Controllers\TenderTypeController;
use App\Http\Controllers\InvoiceChargeMasterController;
use App\Http\Controllers\GrantDeptMapController;
use App\Http\Controllers\FamilyInfoMasterController;
use App\Http\Controllers\EmpEduMasterController;
use App\Http\Controllers\EmppersProfileController;
use App\Http\Controllers\EmployeeGradeMasterController;
use App\Http\Controllers\EmpTypeMasterController;
use App\Http\Controllers\EmployeeStatusMasterController;
use App\Http\Controllers\DesignationMasterController;
use App\Http\Controllers\PayBandMasterController;
use App\Http\Controllers\PayCommissionMasterController;
use App\Http\Controllers\PayScaleMasterController;
use App\Http\Controllers\PayStrtypeMasterController;
use App\Http\Controllers\RelationshipMasterController;
use App\Http\Controllers\CasteMasterController;
use App\Http\Controllers\EmpQuotaMasterController;
use App\Http\Controllers\EmpCatMasterController;
use App\Http\Controllers\EmpLangMasterController;
use App\Http\Controllers\EmployeeMasterController;

use App\Http\Controllers\IncExamMasterController;
use App\Http\Controllers\HolidayMasterController;
use App\Http\Controllers\HolidayDeptMapController;
use App\Http\Controllers\HolidayDsgMapController;
use App\Http\Controllers\HolidayEmpTyMapController;
use App\Http\Controllers\ShiftMasterController;
use App\Http\Controllers\HolidayShiftMapController;
use App\Http\Controllers\LeaveTypeMasterController;


use App\Http\Controllers\SigniWorkMasterController;

use App\Http\Controllers\AwardMasterController;
use App\Http\Controllers\SpecialDutyMasterController;
use App\Http\Controllers\PayAlwdedMasterController;
use App\Http\Controllers\VendInvParameterController;

use App\Http\Controllers\EmpeduProfileController;

use App\Http\Controllers\BranchMasterController;
use App\Http\Controllers\DeptWorkflowController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::prefix('roles')->group(function () {
    Route::get('/lst-role-master', [RoleMasterController::class, 'index']);
    Route::get('/all-role-master', [RoleMasterController::class, 'getAllRolesList']);
    Route::post('/', [RoleMasterController::class, 'store']);
    // Route::post('/bulk', [RoleMasterController::class, 'bulkStore']);
    Route::get('/{id}', [RoleMasterController::class, 'show']);
    Route::put('/{id}', [RoleMasterController::class, 'update']);
    Route::delete('/{id}', [RoleMasterController::class, 'destroy']);
});

Route::prefix('dpt-master')->group(function () {
    Route::get('/lst-dpt-master', [DepartmentController::class, 'index']);                    // Paginated list
    Route::get('/all/lst-dpt-master', [DepartmentController::class, 'getAllDepartments']); // All data without pagination
    Route::post('/', [DepartmentController::class, 'store']);
    Route::get('/active', [DepartmentController::class, 'activeDepartments']);
    Route::get('/{id}', [DepartmentController::class, 'show']);
    Route::put('/{id}', [DepartmentController::class, 'update']);
    Route::delete('/{id}', [DepartmentController::class, 'destroy']);
    Route::get('/building/{building}', [DepartmentController::class, 'getByBuilding']);
    Route::get('/{id}/statistics', [DepartmentController::class, 'getStatistics']);
    Route::post('/check-ip', [DepartmentController::class, 'checkIP']);
    Route::get('/{id}/users', [DepartmentController::class, 'getUsers']);
});

Route::get('profile', [UserMasterController::class, 'profile']);
Route::put('profile', [UserMasterController::class, 'updateProfile']);

// User Management
Route::apiResource('usr-master', UserMasterController::class);
Route::get('/lst-usr-master', [UserMasterController::class, 'getAllUsers']);
Route::post('/{id}/restore', [UserMasterController::class, 'restore']);
Route::post('/{id}/toggle-mfa', [UserMasterController::class, 'toggleMfa']);
Route::post('/{id}/toggle-lock', [UserMasterController::class, 'toggleLock']);
Route::post('/{id}/reset-password', [UserMasterController::class, 'resetPassword']);
Route::get('/{id}/sessions', [UserMasterController::class, 'getUserSessions']);
Route::get('/{id}/audit-logs', [UserMasterController::class, 'getUserAuditLogs']);



Route::get('/lst-usrdpt-map', [UsrDeptMapController::class, 'index']);
Route::post('/usrdpt-map', [UsrDeptMapController::class, 'store']);
Route::get('/usrdpt-map/{id}', [UsrDeptMapController::class, 'show']);
Route::put('/usrdpt-map/{id}', [UsrDeptMapController::class, 'update']);
Route::delete('/usrdpt-map/{id}', [UsrDeptMapController::class, 'destroy']);

Route::prefix('menu-master')->group(function () {
    Route::get('/lst-menu-master', [FunctionTypeController::class, 'index']);
    Route::get('/{id}', [FunctionTypeController::class, 'show']);
    Route::post('/', [FunctionTypeController::class, 'store']);
    Route::put('/{id}', [FunctionTypeController::class, 'update']);
    Route::patch('/{id}', [FunctionTypeController::class, 'update']);
    Route::delete('/{id}', [FunctionTypeController::class, 'destroy']);
});
Route::post('function-types/{id}/toggle-visibility', [FunctionTypeController::class, 'toggleVisibility']);


Route::get('/lst-dptmenu-map', [DeptMenuMapController::class, 'index']);
Route::post('/dptmenu-map', [DeptMenuMapController::class, 'store']);
Route::get('/dptmenu-map/{id}', [DeptMenuMapController::class, 'show']);
Route::put('/dptmenu-map/{id}', [DeptMenuMapController::class, 'update']);
Route::delete('/dptmenu-map/{id}', [DeptMenuMapController::class, 'destroy']);

Route::post('login', [AuthController::class, 'login']);

// Route::apiResource('Org-Master', OrgMasterController::class);

Route::get('/lst-org-master', [OrgMasterController::class, 'index']);
Route::post('/org-master', [OrgMasterController::class, 'store']);
Route::get('/org-master/{id}', [OrgMasterController::class, 'show']);
Route::put('/org-master/{id}', [OrgMasterController::class, 'update']);
Route::delete('/org-master/{id}', [OrgMasterController::class, 'destroy']);

Route::prefix('org-master')->group(function () {
    Route::get('trashed', [OrgMasterController::class, 'trashed']);
    Route::patch('{id}/restore', [OrgMasterController::class, 'restore']);
    Route::delete('{id}/force-delete', [OrgMasterController::class, 'forceDelete']);
});

Route::apiResource('fy-master', FyearMasterController::class);
Route::get('lst-fy-master', [FyearMasterController::class, 'getCurrent']);
Route::post('fy-master/{id}/toggle-budget', [FyearMasterController::class, 'toggleBudget']);
Route::post('fy-master/{id}/toggle-transaction', [FyearMasterController::class, 'toggleTransaction']);

// Route::apiResource('parameters', ParameterController::class);
Route::get('/lst-parameters', [ParameterController::class, 'index']);
Route::post('/parameters', [ParameterController::class, 'store']);
Route::get('/parameters/{id}', [ParameterController::class, 'show']);
Route::put('/parameters/{id}', [ParameterController::class, 'update']);
Route::delete('/parameters/{id}', [ParameterController::class, 'destroy']);

// Route::apiResource('zone-master', ZoneMasterController::class);


Route::get('lst-zone-master', [ZoneMasterController::class, 'index']);
Route::post('zone-master', [ZoneMasterController::class, 'store']);
Route::get('zone-master/all', [ZoneMasterController::class, 'all']);
Route::get('zone-master/{id}', [ZoneMasterController::class, 'show']);
Route::put('zone-master/{id}', [ZoneMasterController::class, 'update']);
Route::delete('zone-master/{id}', [ZoneMasterController::class, 'destroy']);
Route::prefix('zone-master')->group(function () {
    Route::get('organization/{orgId}', [ZoneMasterController::class, 'getByOrganization']);
    Route::get('global', [ZoneMasterController::class, 'getGlobalZones']);
    Route::post('bulk-create', [ZoneMasterController::class, 'bulkStore']);
});

    Route::get('lst-wards', [WardMasterController::class, 'index']);
    Route::post('wards', [WardMasterController::class, 'store']);
       Route::get('wards/all', [WardMasterController::class, 'all']);
    Route::get('wards/{id}', [WardMasterController::class, 'show']);
 
    Route::put('wards/{id}', [WardMasterController::class, 'update']);
    Route::delete('wards/{id}', [WardMasterController::class, 'destroy']);
    Route::post('wards/{id}/restore', [WardMasterController::class, 'restore']);
    Route::get('wards/zone/{zoneId}', [WardMasterController::class, 'getByZone']);

    Route::get('lst-areas', [AreaMasterController::class, 'index']);
Route::post('areas', [AreaMasterController::class, 'store']);
Route::get('areas/{id}', [AreaMasterController::class, 'show']);
Route::put('areas/{id}', [AreaMasterController::class, 'update']);
Route::delete('areas/{id}', [AreaMasterController::class, 'destroy']);

// Custom search route
Route::get('areas/search/query', [AreaMasterController::class, 'search']);


    Route::get('lst-cccs', [CccMasterController::class, 'index']);
    Route::post('cccs', [CccMasterController::class, 'store']);
    Route::get('cccs/{id}', [CccMasterController::class, 'show']);
    Route::put('cccs/{id}', [CccMasterController::class, 'update']);
    Route::delete('cccs/{id}', [CccMasterController::class, 'destroy']);
    Route::post('cccs/{id}/restore', [CccMasterController::class, 'restore']);
    Route::get('cccs/ward/{wardId}', [CccMasterController::class, 'getByWard']);
    Route::get('cccs/zone/{zoneId}', [CccMasterController::class, 'getByZone']);

// Route::apiResource('gr-auth-master', GrantAuthoMasterController::class);

 Route::get('lst-gr-auth-master', [GrantAuthoMasterController::class, 'index']);
 Route::get('gr-auth-master/all', [GrantAuthoMasterController::class, 'all']);
    Route::post('gr-auth-master', [GrantAuthoMasterController::class, 'store']);
    Route::get('gr-auth-master/{id}', [GrantAuthoMasterController::class, 'show']);
    Route::put('gr-auth-master/{id}', [GrantAuthoMasterController::class, 'update']);
    Route::delete('gr-auth-master/{id}', [GrantAuthoMasterController::class, 'destroy']);

Route::post('gr-auth-master/{id}/restore', [GrantAuthoMasterController::class, 'restore']);

// Route::apiResource('grant-types', FasGrantTypeMasterController::class);

 Route::get('lst-grant-types', [GrantTypeMasterController::class, 'index']);
 Route::get('grant-types/all', [GrantTypeMasterController::class, 'all']);
    Route::post('grant-types', [GrantTypeMasterController::class, 'store']);
    Route::get('grant-types/{id}', [GrantTypeMasterController::class, 'show']);
    Route::put('grant-types/{id}', [GrantTypeMasterController::class, 'update']);
    Route::delete('grant-types/{id}', [GrantTypeMasterController::class, 'destroy']);

Route::post('grant-types/{id}/restore', [GrantTypeMasterController::class, 'restore']);


// Route::apiResource('grant-cat-master', GrantCatMasterController::class);
 Route::get('lst-grant-cat', [GrantCatMasterController::class, 'index']);
 Route::get('grant-cat/all', [GrantCatMasterController::class, 'all']);
    Route::post('grant-cat', [GrantCatMasterController::class, 'store']);
    Route::get('grant-cat/{id}', [GrantCatMasterController::class, 'show']);
    Route::put('grant-cat/{id}', [GrantCatMasterController::class, 'update']);
    Route::delete('grant-cat/{id}', [GrantCatMasterController::class, 'destroy']);
    Route::get('grant-cat/trashed/list', [GrantCatMasterController::class, 'trashed']);
    Route::post('grant-cat/{id}/restore', [GrantCatMasterController::class, 'restore']);
    Route::delete('grant-cat/{id}/force', [GrantCatMasterController::class, 'forceDelete']);

    // Route::apiResource('ledg-grps', LedgGrpController::class);

     Route::get('lst-ledg-grps', [LedgGrpController::class, 'index']);
    Route::post('ledg-grps', [LedgGrpController::class, 'store']);
    Route::get('ledg-grps/{id}', [LedgGrpController::class, 'show']);
    Route::put('ledg-grps/{id}', [LedgGrpController::class, 'update']);
    Route::delete('ledg-grps/{id}', [LedgGrpController::class, 'destroy']);


    Route::get('lst-ledgers', [LedgerMasterController::class, 'index']);
    Route::post('ledgers', [LedgerMasterController::class, 'store']);
    Route::post('ledgers/bulk', [LedgerMasterController::class, 'bulkStore']);
    Route::get('ledgers/{id}', [LedgerMasterController::class, 'show']);
    Route::put('ledgers/{id}', [LedgerMasterController::class, 'update']);
    Route::delete('ledgers/{id}', [LedgerMasterController::class, 'destroy']);
    Route::post('ledgers/{id}/activate', [LedgerMasterController::class, 'activate']);
    Route::post('ledgers/{id}/deactivate', [LedgerMasterController::class, 'deactivate']);
    Route::get('ledgers/all/data', [LedgerMasterController::class, 'all']);
    


    Route::apiResource('schemes', SchemeMasterController::class);
      Route::get('lst-schemes', [SchemeMasterController::class, 'index']);
       Route::get('schemes/all', [SchemeMasterController::class, 'all']);
    Route::post('schemes', [SchemeMasterController::class, 'store']);
    Route::post('schemes/bulk', [SchemeMasterController::class, 'bulkStore']);
    Route::get('schemes/{id}', [SchemeMasterController::class, 'show']);
    Route::put('schemes/{id}', [SchemeMasterController::class, 'update']);
    Route::delete('schemes/{id}', [SchemeMasterController::class, 'destroy']);
Route::post('schemes/{id}/restore', [SchemeMasterController::class, 'restore']);

Route::apiResource('debt-types', DebtTypeMasterController::class);

      Route::get('lst-debt-type', [DebtTypeMasterController::class, 'index']);
       Route::get('debt-type/all', [DebtTypeMasterController::class, 'all']);
    Route::post('debt-type', [DebtTypeMasterController::class, 'store']);
    Route::post('debt-type/bulk', [DebtTypeMasterController::class, 'bulkStore']);
    Route::get('debt-type/{id}', [DebtTypeMasterController::class, 'show']);
    Route::put('debt-type/{id}', [DebtTypeMasterController::class, 'update']);
    Route::delete('debt-type/{id}', [DebtTypeMasterController::class, 'destroy']);
Route::post('debt-types/{id}/restore', [DebtTypeMasterController::class, 'restore']);
Route::get('debt-types/options', [DebtTypeMasterController::class, 'getOptions']);



    Route::get('/lst-tender-type', [TenderTypeController::class, 'index']);
    Route::get('tender-type/all', [TenderTypeController::class, 'getAllWithoutPagination']);
    Route::post('tender-type', [TenderTypeController::class, 'store']);
    Route::get('tender-type/{id}', [TenderTypeController::class, 'show']);
    Route::put('tender-type/{id}', [TenderTypeController::class, 'update']);
    Route::delete('tender-type/{id}', [TenderTypeController::class, 'destroy']);

    Route::post('tender-type/{id}/restore', [TenderTypeController::class, 'restore']);
    Route::delete('tender-type/{id}/force-delete', [TenderTypeController::class, 'forceDelete']);
    Route::post('tender-type/bulk', [TenderTypeController::class, 'bulkStore']);
    Route::get('tender-type/active/list', [TenderTypeController::class, 'active']);


    // CRUD routes
    Route::get('/lst-emdbg-type', [EmdbgTypeController::class, 'index']);
    Route::post('emdbg-type', [EmdbgTypeController::class, 'store']);
    Route::get('emdbg-type/{id}', [EmdbgTypeController::class, 'show']);
    Route::put('emdbg-type/{id}', [EmdbgTypeController::class, 'update']);
    Route::delete('emdbg-type/{id}', [EmdbgTypeController::class, 'destroy']);

    // Additional routes
    Route::post('emdbg-type/{id}/restore', [EmdbgTypeController::class, 'restore']);
    Route::delete('emdbg-type/{id}/force-delete', [EmdbgTypeController::class, 'forceDelete']);
    Route::post('emdbg-type/bulk', [EmdbgTypeController::class, 'bulkStore']);
    Route::get('emdbg-type/active/list', [EmdbgTypeController::class, 'active']);
    Route::get('emdbg-type/search/advanced', [EmdbgTypeController::class, 'search']);


// Route::prefix('sub-ledgers')->group(function () {
    Route::get('lst-sub-ledgers', [SubLedgerMasterController::class, 'index']);
    Route::get('sub-ledgers/all', [SubLedgerMasterController::class, 'getAll']);
    Route::post('sub-ledgers', [SubLedgerMasterController::class, 'store']);
    Route::get('sub-ledgers/{id}', [SubLedgerMasterController::class, 'show']);
    Route::put('sub-ledgers/{id}', [SubLedgerMasterController::class, 'update']);
    Route::delete('sub-ledgers/{id}', [SubLedgerMasterController::class, 'destroy']);

    Route::post('sub-ledgers/{id}/deactivate', [SubLedgerMasterController::class, 'deactivate']);
    Route::post('sub-ledgers/{id}/activate', [SubLedgerMasterController::class, 'activate']);
    Route::get('sub-ledgers/ledger/{ledgerId}', [SubLedgerMasterController::class, 'getByLedger']);
    Route::post('sub-ledgers/bulk', [SubLedgerMasterController::class, 'bulkStore']);
    Route::get('sub-ledgers/statistics', [SubLedgerMasterController::class, 'getStatistics']);
    Route::get('sub-ledgers/compliance-report', [SubLedgerMasterController::class, 'getComplianceReport']);

    // New routes for statutory and banking
    Route::post('sub-ledgers/{id}/verify-pan', [SubLedgerMasterController::class, 'verifyPAN']);
    Route::post('sub-ledgers/{id}/verify-gstin', [SubLedgerMasterController::class, 'verifyGSTIN']);
    Route::post('sub-ledgers/{id}/verify-bank-details', [SubLedgerMasterController::class, 'verifyBankDetails']);
    Route::post('sub-ledgers/{id}/unverify-pan', [SubLedgerMasterController::class, 'unverifyPAN']);
    Route::post('sub-ledgers/{id}/unverify-gstin', [SubLedgerMasterController::class, 'unverifyGSTIN']);
    Route::post('sub-ledgers/{id}/unverify-bank-details', [SubLedgerMasterController::class, 'unverifyBankDetails']);

    // File routes
    Route::get('sub-ledgers/{id}/download-cancelled-cheque', [SubLedgerMasterController::class, 'downloadCancelledCheque']);
    Route::delete('sub-ledgers/{id}/delete-cancelled-cheque', [SubLedgerMasterController::class, 'deleteCancelledCheque']);


    Route::get('lst-invoice-charges', [InvoiceChargeMasterController::class, 'index']);
    Route::post('invoice-charges', [InvoiceChargeMasterController::class, 'store']);
    Route::get('invoice-charges/{id}', [InvoiceChargeMasterController::class, 'show']);
    Route::put('invoice-charges/{id}', [InvoiceChargeMasterController::class, 'update']);
    Route::delete('invoice-charges/{id}', [InvoiceChargeMasterController::class, 'destroy']);




    Route::get('/lst-grant-dept-map', [GrantDeptMapController::class, 'index']);
    Route::get('grant-dept-map/all', [GrantDeptMapController::class, 'all']); // List all
    Route::post('grant-dept-map', [GrantDeptMapController::class, 'store']);             // Create
    Route::get('grant-dept-map/{id}', [GrantDeptMapController::class, 'show']);           // Get single
    Route::put('grant-dept-map/{id}', [GrantDeptMapController::class, 'update']);         // Update
    Route::delete('grant-dept-map/{id}', [GrantDeptMapController::class, 'destroy']);     // Delete

    // Extra endpoints
    Route::get('grant-dept-map/search', [GrantDeptMapController::class, 'search']);
    Route::get('grant-dept-map/by-department/{deptId}', [GrantDeptMapController::class, 'byDepartment']);
    Route::get('grant-dept-map/by-ledger/{ledgId}', [GrantDeptMapController::class, 'byLedger']);
    Route::get('grant-dept-map/departments-for-ledger/{ledgId}', [GrantDeptMapController::class, 'departmentsForLedger']);
    Route::get('grant-dept-map/ledgers-for-department/{deptId}', [GrantDeptMapController::class, 'ledgersForDepartment']);

    // Add/Remove ledgers
    Route::post('grant-dept-map/{id}/add-ledgers', [GrantDeptMapController::class, 'addLedgers']);
    Route::post('grant-dept-map/{id}/remove-ledgers', [GrantDeptMapController::class, 'removeLedgers']);

    Route::get('lst-funds-types', [FundsTypeMasterController::class, 'index']);
    Route::post('funds-types', [FundsTypeMasterController::class, 'store']);
    Route::get('funds-types/{id}', [FundsTypeMasterController::class, 'show']);
    Route::put('funds-types/{id}', [FundsTypeMasterController::class, 'update']);
    Route::put('funds-types/{id}/deactivate', [FundsTypeMasterController::class, 'destroy']);
    Route::put('funds-types/{id}/activate', [FundsTypeMasterController::class, 'restore']);
    Route::get('funds-types/all', [FundsTypeMasterController::class, 'getAll']);
    Route::get('funds-types/by-grant-type/{grantTypeId}', [FundsTypeMasterController::class, 'getByGrantType']);


Route::get('lst-pay-strtyp', [PayStrtypeMasterController::class, 'index']);    
Route::get('pay-strtyp/all', [PayStrtypeMasterController::class, 'all']);    
Route::post('pay-strtype', [PayStrtypeMasterController::class, 'store']);
Route::get('pay-strtype/{id}', [PayStrtypeMasterController::class, 'show']);
Route::put('pay-strtype/{id}', [PayStrtypeMasterController::class, 'update']);
Route::delete('pay-strtype/{id}', [PayStrtypeMasterController::class, 'destroy']);



Route::get('lst-pay-commission', [PayCommissionMasterController::class, 'index']);    
Route::get('pay-commission/all', [PayCommissionMasterController::class, 'all']);    
Route::post('pay-commission', [PayCommissionMasterController::class, 'store']);
Route::get('pay-commission/{id}', [PayCommissionMasterController::class, 'show']);
Route::put('pay-commission/{id}', [PayCommissionMasterController::class, 'update']);
Route::delete('pay-commission/{id}', [PayCommissionMasterController::class, 'destroy']);
Route::get('pay-commission/{id}/details', [PayCommissionMasterController::class, 'getCommissionDetails']);




Route::get('lst-pay-bands', [PayBandMasterController::class, 'index']);    
Route::get('pay-bands/all', [PayBandMasterController::class, 'all']);    
Route::post('pay-bands', [PayBandMasterController::class, 'store']);
Route::get('pay-bands/{id}', [PayBandMasterController::class, 'show']);
Route::put('pay-bands/{id}', [PayBandMasterController::class, 'update']);
Route::delete('pay-bands/{id}', [PayBandMasterController::class, 'destroy']);
Route::get('pay-bands/commission/{commissionId}', [PayBandMasterController::class, 'getByCommission']);




Route::get('/lst-emp-grade', [EmployeeGradeMasterController::class, 'index']);  
Route::get('/emp-grade/all', [EmployeeGradeMasterController::class, 'all']);   
Route::post('/emp-grade', [EmployeeGradeMasterController::class, 'store']);
Route::get('/emp-grade/{id}', [EmployeeGradeMasterController::class, 'show']);
Route::put('/emp-grade/{id}', [EmployeeGradeMasterController::class, 'update']);
Route::delete('/emp-grade/{id}', [EmployeeGradeMasterController::class, 'destroy']);




Route::get('lst-pay-scales', [PayScaleMasterController::class, 'index']);    
Route::get('pay-scales/all', [PayScaleMasterController::class, 'all']);    
Route::post('pay-scales', [PayScaleMasterController::class, 'store']);
Route::get('pay-scales/{id}', [PayScaleMasterController::class, 'show']);
Route::put('pay-scales/{id}', [PayScaleMasterController::class, 'update']);
Route::delete('pay-scales/{id}', [PayScaleMasterController::class, 'destroy']);
Route::get('pay-scales/commission/{commissionId}', [PayScaleMasterController::class, 'getByCommission']);

Route::get('lst-emp-type', [EmpTypeMasterController::class, 'index']);
Route::get('emp-type/all', [EmpTypeMasterController::class, 'all']);
Route::post('/emp-type', [EmpTypeMasterController::class, 'store']);
Route::get('/emp-type/{id}', [EmpTypeMasterController::class, 'show']);
Route::put('/emp-type/{id}', [EmpTypeMasterController::class, 'update']);
Route::delete('/emp-type/{id}', [EmpTypeMasterController::class, 'destroy']);




Route::get('lst-emp-statuse', [EmployeeStatusMasterController::class, 'index']);
Route::get('emp-statuse/all', [EmployeeStatusMasterController::class, 'all']);
Route::post('emp-statuse', [EmployeeStatusMasterController::class, 'store']);
Route::get('emp-statuse/{id}', [EmployeeStatusMasterController::class, 'show']);
Route::put('emp-statuse/{id}', [EmployeeStatusMasterController::class, 'update']);
Route::delete('emp-statuse/{id}', [EmployeeStatusMasterController::class, 'destroy']);


Route::get('lst-relmaster', [RelationshipMasterController::class, 'index']);
Route::get('relmaster/all', [RelationshipMasterController::class, 'all']);
Route::post('relmaster', [RelationshipMasterController::class, 'store']);
Route::get('relmaster/{id}', [RelationshipMasterController::class, 'show']);
Route::put('relmaster/{id}', [RelationshipMasterController::class, 'update']);
Route::delete('relmaster/{id}', [RelationshipMasterController::class, 'destroy']);


Route::get('lst-designation', [DesignationMasterController::class, 'index']);
Route::get('designation/all', [DesignationMasterController::class, 'all']);
Route::post('designation', [DesignationMasterController::class, 'store']);
Route::get('designation/{id}', [DesignationMasterController::class, 'show']);
Route::put('designation/{id}', [DesignationMasterController::class, 'update']);
Route::delete('designation/{id}', [DesignationMasterController::class, 'destroy']);


Route::get('lst-caste-master', [CasteMasterController::class, 'index']);
Route::get('caste-master/all', [CasteMasterController::class, 'all']);
Route::post('caste-master', [CasteMasterController::class, 'store']);
Route::get('caste-master/{id}', [CasteMasterController::class, 'show']);
Route::put('caste-master/{id}', [CasteMasterController::class, 'update']);
Route::delete('caste-master/{id}', [CasteMasterController::class, 'destroy']);


Route::get('lst-emp-quota', [EmpQuotaMasterController::class, 'index']); // pagination
Route::get('emp-quota/all', [EmpQuotaMasterController::class, 'all']); // all data
Route::post('emp-quota', [EmpQuotaMasterController::class, 'store']);
Route::get('emp-quota/{id}', [EmpQuotaMasterController::class, 'show']);
Route::put('emp-quota/{id}', [EmpQuotaMasterController::class, 'update']);
Route::delete('emp-quota/{id}', [EmpQuotaMasterController::class, 'destroy']);


Route::get('lst-emp-category', [EmpCatMasterController::class, 'index']);
Route::post('emp-category', [EmpCatMasterController::class, 'store']);
Route::get('emp-category/all', [EmpCatMasterController::class, 'all']);
Route::get('emp-category/{id}', [EmpCatMasterController::class, 'show']);
Route::put('emp-category/{id}', [EmpCatMasterController::class, 'update']);
Route::delete('emp-category/{id}', [EmpCatMasterController::class, 'destroy']);
Route::patch('emp-category/status/{id}', [EmpCatMasterController::class, 'changeStatus']);


Route::get('lst-emp-lang', [EmpLangMasterController::class, 'index']);
Route::post('emp-lang', [EmpLangMasterController::class, 'store']);
Route::get('emp-lang/all', [EmpLangMasterController::class, 'all']);
Route::get('emp-lang/{id}', [EmpLangMasterController::class, 'show']);
Route::put('emp-lang/{id}', [EmpLangMasterController::class, 'update']);
Route::delete('emp-lang/{id}', [EmpLangMasterController::class, 'destroy']);



Route::get('lst-emp-mast', [EmployeeMasterController::class, 'index']);     // Pagination + Search
Route::get('emp-mast/all', [EmployeeMasterController::class, 'all']);     // All Data

Route::get('emp-mast/{id}', [EmployeeMasterController::class, 'show']);   // Single Record

Route::post('emp-mast', [EmployeeMasterController::class, 'store']);     // Create
Route::put('emp-mast/{id}', [EmployeeMasterController::class, 'update']); // Update

Route::delete('emp-mast/{id}', [EmployeeMasterController::class, 'destroy']); // Delete


//======================================//

Route::get('lst/inc-exam', [IncExamMasterController::class, 'index']);
Route::get('all/inc-exam', [IncExamMasterController::class, 'getAllExams']);
Route::post('inc-exam', [IncExamMasterController::class, 'store']);
Route::get('inc-exam/{id}', [IncExamMasterController::class, 'show']);
Route::put('inc-exam/{id}', [IncExamMasterController::class, 'update']);
Route::delete('inc-exam/{id}', [IncExamMasterController::class, 'destroy']);


// Holiday Master Routes
Route::get('lst-holiday', [HolidayMasterController::class, 'index']);
Route::get('holiday/all', [HolidayMasterController::class, 'all']);
Route::post('holiday', [HolidayMasterController::class, 'store']);
Route::get('holiday/{id}', [HolidayMasterController::class, 'show']);
Route::put('holiday/{id}', [HolidayMasterController::class, 'update']);
Route::delete('holiday/{id}', [HolidayMasterController::class, 'destroy']);


// Holiday Department Map Routes
Route::get('lst-holiday-dept-map', [HolidayDeptMapController::class, 'index']);
Route::get('holiday-dept-map/all', [HolidayDeptMapController::class, 'all']);
Route::post('holiday-dept-map', [HolidayDeptMapController::class, 'store']);
Route::get('holiday-dept-map/{id}', [HolidayDeptMapController::class, 'show']);
Route::put('holiday-dept-map/{id}', [HolidayDeptMapController::class, 'update']);
Route::delete('holiday-dept-map/{id}', [HolidayDeptMapController::class, 'destroy']);


Route::get('lst-holiday-dsg-map', [HolidayDsgMapController::class, 'index']);
Route::get('holiday-dsg-map/all', [HolidayDsgMapController::class, 'all']);
Route::post('holiday-dsg-map', [HolidayDsgMapController::class, 'store']);
Route::get('holiday-dsg-map/{id}', [HolidayDsgMapController::class, 'show']);
Route::put('holiday-dsg-map/{id}', [HolidayDsgMapController::class, 'update']);
Route::delete('holiday-dsg-map/{id}', [HolidayDsgMapController::class, 'destroy']);


Route::get('lst-holiday-emptymap', [HolidayEmpTyMapController::class, 'index']);
Route::get('holiday-emptymap/all', [HolidayEmpTyMapController::class, 'all']);
Route::post('holiday-emptymap', [HolidayEmpTyMapController::class, 'store']);
Route::get('holiday-emptymap/{id}', [HolidayEmpTyMapController::class, 'show']);
Route::put('holiday-emptymap/{id}', [HolidayEmpTyMapController::class, 'update']);
Route::delete('holiday-emptymap/{id}', [HolidayEmpTyMapController::class, 'destroy']);

Route::get('lst-shift', [ShiftMasterController::class, 'index']);
Route::get('shift/all', [ShiftMasterController::class, 'all']);
Route::post('shift', [ShiftMasterController::class, 'store']);
Route::get('shift/{id}', [ShiftMasterController::class, 'show']);
Route::put('shift/{id}', [ShiftMasterController::class, 'update']);
Route::delete('shift/{id}', [ShiftMasterController::class, 'destroy']);


Route::get('lst-holiday-shift-map', [HolidayShiftMapController::class, 'index']);
Route::get('holiday-shift-map/all', [HolidayShiftMapController::class, 'all']);
Route::post('holiday-shift-map', [HolidayShiftMapController::class, 'store']);
Route::get('holiday-shift-map/{id}', [HolidayShiftMapController::class, 'show']);
Route::put('holiday-shift-map/{id}', [HolidayShiftMapController::class, 'update']);
Route::delete('holiday-shift-map/{id}', [HolidayShiftMapController::class, 'destroy']);

Route::get('lst-leave-type', [LeaveTypeMasterController::class, 'index']);
Route::get('leave-type/all', [LeaveTypeMasterController::class, 'all']);
Route::post('leave-type', [LeaveTypeMasterController::class, 'store']);
Route::get('leave-type/{id}', [LeaveTypeMasterController::class, 'show']);
Route::put('leave-type/{id}', [LeaveTypeMasterController::class, 'update']);
Route::delete('leave-type/{id}', [LeaveTypeMasterController::class, 'destroy']);


Route::get('lst-signi-work', [SigniWorkMasterController::class, 'index']);
Route::get('signi-work/all', [SigniWorkMasterController::class, 'all']);
Route::post('signi-work', [SigniWorkMasterController::class, 'store']);
Route::get('signi-work/{id}', [SigniWorkMasterController::class, 'show']);
Route::put('signi-work/{id}', [SigniWorkMasterController::class, 'update']);
Route::delete('signi-work/{id}', [SigniWorkMasterController::class, 'destroy']);




Route::get('lst-emp-edu', [EmpEduMasterController::class, 'index']);
Route::get('emp-edu/all', [EmpEduMasterController::class, 'all']);
Route::get('emp-edu/{id}', [EmpEduMasterController::class, 'show']);
Route::post('emp-edu', [EmpEduMasterController::class, 'store']);
Route::put('emp-edu/{id}', [EmpEduMasterController::class, 'update']);
Route::delete('emp-edu/{id}', [EmpEduMasterController::class, 'destroy']);



Route::get('lst-family-info', [FamilyInfoMasterController::class, 'index']);
Route::get('family-info/all', [FamilyInfoMasterController::class, 'all']);

Route::get('family-info/{id}', [FamilyInfoMasterController::class, 'show']);

Route::post('family-info', [FamilyInfoMasterController::class, 'store']);
Route::put('family-info/{id}', [FamilyInfoMasterController::class, 'update']);

Route::delete('family-info/{id}', [FamilyInfoMasterController::class, 'destroy']);





Route::get('lst-emppers-profile', [EmpPersProfileController::class, 'index']);
Route::get('emppers-profile/all', [EmpPersProfileController::class, 'all']);

Route::get('emppers-profile/{id}', [EmpPersProfileController::class, 'show']);

Route::post('emppers-profile', [EmpPersProfileController::class, 'store']);
Route::put('emppers-profile/{id}', [EmpPersProfileController::class, 'update']);

Route::delete('emppers-profile/{id}', [EmpPersProfileController::class,
'destroy']);



Route::get('lst-empedu-profile', [EmpeduProfileController::class, 'index']);
Route::get('empedu-profile/all', [EmpeduProfileController::class, 'all']);
Route::get('empedu-profile/{id}', [EmpeduProfileController::class, 'show']);
Route::post('empedu-profile', [EmpeduProfileController::class, 'store']);
Route::put('empedu-profile/{id}', [EmpeduProfileController::class, 'update']);
Route::delete('empedu-profile/{id}', [EmpeduProfileController::class, 'destroy']);


Route::get('lst-award', [AwardMasterController::class, 'index']); // pagination + search
Route::get('award/all', [AwardMasterController::class, 'all']); // all data
Route::get('award/{id}', [AwardMasterController::class, 'show']); // single
Route::post('award', [AwardMasterController::class, 'store']);
Route::post('award/update/{id}', [AwardMasterController::class, 'update']);
Route::delete('award/delete/{id}', [AwardMasterController::class, 'destroy']);

Route::get('lst-special-duty', [SpecialDutyMasterController::class, 'index']); // pagination + search
Route::get('special-duty/all', [SpecialDutyMasterController::class, 'all']); // all data
Route::get('special-duty/{id}', [SpecialDutyMasterController::class, 'show']); // single
Route::post('special-duty', [SpecialDutyMasterController::class, 'store']);
Route::post('special-duty/{id}', [SpecialDutyMasterController::class, 'update']);
Route::delete('special-duty/{id}', [SpecialDutyMasterController::class, 'destroy']);

Route::get('lst-pay-alwded', [PayAlwdedMasterController::class, 'index']);
Route::post('pay-alwded', [PayAlwdedMasterController::class, 'store']);
Route::get('pay-alwded/{id}', [PayAlwdedMasterController::class, 'show']);
Route::put('pay-alwded/{id}', [PayAlwdedMasterController::class, 'update']);
Route::delete('pay-alwded/{id}', [PayAlwdedMasterController::class, 'destroy']);
Route::get('pay-alwded-all', [PayAlwdedMasterController::class, 'all']);



// Route::apiResource('vendinv-parameter', VendInvParameterController::class);
Route::get('lst-vendinv-parameter', [VendInvParameterController::class, 'index']);
Route::post('vendinv-parameter', [VendInvParameterController::class, 'store']);
Route::get('vendinv-parameter/{id}', [VendInvParameterController::class, 'show']);
Route::put('vendinv-parameter/{id}', [VendInvParameterController::class, 'update']);
Route::delete('vendinv-parameter/{id}', [VendInvParameterController::class, 'destroy']);
Route::get('vendinv-parameter/all', [VendInvParameterController::class, 'all']);
Route::get('vendinv-parameter/tender/{TnT_ID}', [VendInvParameterController::class, 'showByTender']);



Route::get('lst-branch', [BranchMasterController::class, 'index']);
Route::get('branch/all', [BranchMasterController::class, 'all']);
Route::post('branch', [BranchMasterController::class, 'store']);
Route::get('branch/{id}', [BranchMasterController::class, 'show']);
Route::put('branch/{id}', [BranchMasterController::class, 'update']);
Route::delete('branch/{id}', [BranchMasterController::class, 'destroy']);
Route::post('branch/restore/{id}', [BranchMasterController::class, 'restore']);
Route::delete('branch/force-delete/{id}', [BranchMasterController::class, 'forceDelete']);
Route::get('branch/trashed/list', [BranchMasterController::class, 'trashed']);


Route::get('lst-dept-workflow', [DeptWorkflowController::class, 'index']);
Route::get('dept-workflow/all', [DeptWorkflowController::class, 'all']);
Route::post('dept-workflow', [DeptWorkflowController::class, 'store']);
Route::get('dept-workflow/{id}', [DeptWorkflowController::class, 'show']);
Route::put('dept-workflow/{id}', [DeptWorkflowController::class, 'update']);
Route::delete('dept-workflow/{id}', [DeptWorkflowController::class, 'destroy']);
Route::get('dept-workflow/all', [DeptWorkflowController::class, 'all']);
Route::get('dept-workflow dept/{id}', [DeptWorkflowController::class, 'departmentWise']);
